#include <stdio.h>
#include <stdlib.h>

#define SKUP_B 1
#define SKUP_N 0

int m, n; // m - broj jednacina (ogranicenja), n - broj promenljivih

double **a; // matrica koeficijenata
double *b; // slobodni clanovi ogranicenja
double *c; // koeficijenti ciljne funkcije
double *x; // vrednosti promenljivih
int *BN; // 0 - clan skupa N, skupa sporednih promenljivih
		 // 1 - clan skupa B, skupa osnovnih promenljivih

// Svi nizovi su dimenzije m+n zbog lakseg prevodjenja ulaznih
// promenljiva u izlazne prilikom pivotiranja.

double v; //slobodni clan u ciljnoj funkciji z


void UnesiPodatke() {
	int i, j;
	double satiP1, satiP2,CuP1, CuP2,AlP1, AlP2, zalihaCu, zalihaAl, potraznjaCu, potraznjaAl;
	m = 4; // broj nejednacina
	n = 2; // broj nepoznatih - Cu, AL
	
	a = (double **)malloc((n+m)*sizeof(double *));
	for (i=0; i<(n+m); i++)
		a[i] = (double *)malloc((n+m)*sizeof(double));
	
	b = (double *)malloc((n+m)*sizeof(double));
	c = (double *)malloc((n+m)*sizeof(double));
	x = (double *)malloc((n+m)*sizeof(double));
	BN = (int *)malloc((n+m)*sizeof(int));
	
	for (i=0; i<n; i++)
	{
		//scanf("%lf", &c[i]);
		c[i] = 1.0;
		BN[i] = SKUP_N;
		b[i] = 0.0;
	}
	
	for (i=n; i<n+m; i++)
	{
		//scanf("%lf", &b[i]);
		BN[i] = SKUP_B;
		c[i] = 0.0;
	}
	
	scanf("%lf%lf", &satiP1, &satiP2);
	scanf("%lf%lf", &CuP1, &CuP2);
	scanf("%lf%lf", &AlP1, &AlP2);
	scanf("%lf%lf", &zalihaCu, &zalihaAl);
	scanf("%lf%lf", &potraznjaCu, &potraznjaAl);

	


	
	a[n][0] = CuP1;
	a[n][1] = AlP1;
	b[n] = 60 * satiP1;
	
	a[n+1][0] = CuP2;
	a[n+1][1] = AlP2;
	b[n+1] = 60 * satiP2;
	
	a[n+2][0] = -1.0;
	a[n+2][1] = 0.0;
	b[n+2] = zalihaCu - potraznjaCu;

	a[n+3][0] = 0.0;
	a[n+3][1] = -1.0;
	b[n+3] = zalihaAl - potraznjaAl;

	//v = zalihaCu + zalihaAl - potraznjaCu - potraznjaAl;
	v = 0.0;
	

}


int nadjiUlaz() {
	int i;
	
	int e = -1;
	for (i=0; i<n+m; i++) {
		if (BN[i]==SKUP_N && c[i]>0) {
			e = i;
			break;
		}
	}
	return e;
}

int nadjiIzlaz(int e) {
	int l, i;
	double min;
	
	l = -1;
	
	for (i=0; i<m+n; i++) {
		if (BN[i]==SKUP_B && a[i][e]>0) {
			if (l==-1) {
				min = b[i]/a[i][e];
				l = i;
			}
			else {
				if (b[i]/a[i][e] < min) {
					min = b[i]/a[i][e];
					l = i;
				}
			}
		}
	}
	
	return l;
}

void pivot(int e, int l) {
	int i,j;
	b[e] = b[l]/a[l][e];
	for (j=0; j<n+m; j++) {
		if (BN[j]==SKUP_N && j!=e) {
			a[e][j] = a[l][j]/a[l][e];
		}
	}
	a[e][l] = 1/a[l][e];
	
	for (i=0; i<n+m; i++) {
		if (BN[i]==SKUP_B && i!=l) {
			b[i] = b[i]-a[i][e]*b[e];
			for (j=0; j<m+n; j++) {
				if (BN[j]==SKUP_N && j!=e) {
					a[i][j] = a[i][j]-a[i][e]*a[e][j];
				}
			}
			a[i][l] = -a[i][e]*a[e][l];
		}
	}
	
	v = v + c[e]*b[e];
	for (j=0; j<m+n; j++) {
		if (BN[j]==SKUP_N && j!=e) {
			c[j] = c[j]-c[e]*a[e][j];
		}
	}
	c[l] = -c[e]*a[e][l];
	
	BN[e] = SKUP_B;
	BN[l] = SKUP_N;
}

int main() {
	int e, l;
	int i, j;
	
	UnesiPodatke();
	
	while ( (e=nadjiUlaz())!=-1 ) {
		l = nadjiIzlaz(e);
		if (l==-1) {
			printf("Problem neogranicen.\n");
			break;
		}
		else {
			pivot(e,l);
		}
	}
	
	if (e==-1) {
		for (j=0; j<n; j++) {
			if (BN[j]==SKUP_B) {
				x[j] = b[j];
			}
			else {
				x[j] = 0;
			}
		}
		
		for (j=0; j<n; j++) {
			printf("%lf\n", x[j]);
		}
		//printf("\n%lf\n", v);
	}

	return 0;
	
}












